﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NomeScripts
{
    static class SoundEvents
    {
        /// <summary>
        /// Play an in game, get sound names from sounds.dat15
        /// </summary>
        /// <param name="audioName">Name of sound</param>
        public static void PlayAudioEvent(string audioName)
        {
            GTA.Native.Function.Call("PLAY_AUDIO_EVENT", audioName);
        }

        /// <summary>
        /// Play an in game sound from a pedestrian, get sound names from sounds.dat15
        /// </summary>
        /// <param name="audioName">Name of sound</param>
        /// <param name="ped">Ped to play sound from</param>
        public static void PlayAudioEventFromPed(string audioName, GTA.Ped ped)
        {
            GTA.Native.Function.Call("PLAY_AUDIO_EVENT_FROM_PED", audioName, ped);
        }

        /// <summary>
        /// Play an in game sound from a vehicle, get sound names from sounds.dat15
        /// </summary>
        /// <param name="audioName">Name of sound</param>
        /// <param name="veh">Vehicle to play sound from</param>
        public static void PlayAudioEventFromVehicle(string audioName, GTA.Vehicle veh)
        {
            GTA.Native.Function.Call("PLAY_AUDIO_EVENT_FROM_VEHICLE", audioName, veh);
        }

        /// <summary>
        /// Play an in game sound from an object, get sound names from sounds.dat15
        /// </summary>
        /// <param name="audioName">Name of sound<</param>
        /// <param name="obj">Object to play sound from</param>
        public static void PlayAudioEventFromObject(string audioName, GTA.Object obj)
        {
            GTA.Native.Function.Call("PLAY_AUDIO_EVENT_FROM_OBJECT", audioName, obj);
        }
    }
}
